// ultrasonic    D2,D3
//servo          D5
//    L = Left
//    R = Right
//    F = Forward
//    B = Back

#include <Servo.h> 
#include <DistanceSRF04.h>
DistanceSRF04 Dist;
int MotorLeft1 =8;   //IN1
int MotorLeft2 = 11; //IN2
int MotorRight1 = 12;  //IN3
int MotorRight2 = 13;  //IN4
int EA = 9;    //enable out1
int EB = 10;   //enable out2

uint8_t MotorLeft1Status = LOW;
uint8_t MotorLeft2Status = LOW;
uint8_t MotorRight1Status = LOW;
uint8_t MotorRight2Status = LOW;

int Fspeedd = 0;      // the speed of go forward
int Rspeedd = 0;      // 
int Lspeedd = 0;      // 
int directionn = 0;   // advance=8 back=2 left=4 right=6 
Servo myservo;        //  myservo
int delay_time = 250; // servo stop time

int Fgo = 8;         // go forward
int Rgo = 6;         // turn right
int Lgo = 4;         // turn letf
int Bgo = 2;         // back
void setup()
 {
        Serial.begin(9600);     // 
        Dist.begin(3,2);
 	pinMode(MotorLeft1, OUTPUT);
	pinMode(MotorLeft2, OUTPUT);
	pinMode(MotorRight1, OUTPUT);
	pinMode(MotorRight2, OUTPUT);
        myservo.attach(6);    // servo interface
 }
void advance(int a)     // go forward
    {
	MotorLeft1Status = LOW;
	MotorLeft2Status = HIGH;
	MotorRight1Status = LOW;
	MotorRight2Status = HIGH;
	SetEN();
     delay(a * 100);     
    }
void right(int b)        //turn right
    {
 	MotorLeft1Status = LOW;
	MotorLeft2Status = HIGH;
	MotorRight1Status = HIGH;
	MotorRight2Status = LOW;
	SetEN();
     delay(b * 100);
    }
void left(int c)         //turn left
    {
 	MotorLeft1Status = HIGH;
	MotorLeft2Status = LOW;
	MotorRight1Status = LOW;
	MotorRight2Status = HIGH;
	SetEN();
     delay(c * 100);
    }

void turnR(int d)        //turn right
    {
	MotorLeft1Status = LOW;
	MotorLeft2Status = HIGH;
	MotorRight1Status = HIGH;
	MotorRight2Status = LOW;
	SetEN();
     delay(d * 100);
    }
void turnL(int e)        //turn left
    {
	MotorLeft1Status = HIGH;
	MotorLeft2Status = LOW;
	MotorRight1Status = LOW;
	MotorRight2Status = HIGH;
	SetEN();
     delay(e * 100);
    }    
void stopp(int f)         //stop
    {
	MotorLeft1Status = LOW;
	MotorLeft2Status = LOW;
	MotorRight1Status = LOW;
	MotorRight2Status = LOW;
	SetEN();
     delay(f * 100);
    }
void back(int g)          //back
 {
   	MotorLeft1Status = HIGH;
	MotorLeft2Status = LOW;
	MotorRight1Status = HIGH;
	MotorRight2Status = LOW;
	SetEN();
     delay(g * 100);     
    }
 void SetEN(){
	digitalWrite(EA, HIGH);
	digitalWrite(EB, HIGH);
	digitalWrite(MotorLeft1, MotorLeft1Status);
	digitalWrite(MotorLeft2, MotorLeft2Status);
	digitalWrite(MotorRight1, MotorRight1Status);
	digitalWrite(MotorRight2, MotorRight2Status);
}
   
void detection()        //test angle(0.90.179)
    {      
      int delay_time = 250;   // the time of sevo stability
      ask_pin_F();            // test the distance of forward
      
     if(Fspeedd < 10)         
      {
      stopp(1);            
      back(2);                // back 0.2 s
      }
           
      if(Fspeedd < 25)        
      {
        stopp(1);             
        ask_pin_L();            
        delay(delay_time);    
        ask_pin_R();            // test the distance of right
        delay(delay_time);      // wait the servo stability  
        
        if(Lspeedd > Rspeedd)  
        {
         directionn = Rgo;      //turn right
        }
        
        if(Lspeedd <= Rspeedd)   
        {
         directionn = Lgo;      //turn left
        } 
        
        if (Lspeedd < 10 && Rspeedd < 10)   
        {
         directionn = Bgo;      //back        
        }          
      }
      else                         
      {
        directionn = Fgo;        //go forward     
      }
     
    }    
void ask_pin_F()   // test the distance of forward
    {
      myservo.write(90);
      int Fdistance= Dist.getDistanceCentimeter();      
      Serial.print("F distance:");      
      Serial.println(Fdistance);        
      Fspeedd = Fdistance;              
    }  
 void ask_pin_L()   
    {
      myservo.write(5);
      int Ldistance=Dist.getDistanceCentimeter();      
      Serial.print("L distance:");       
      Serial.println(Ldistance);         
      Lspeedd = Ldistance;              
    }  
void ask_pin_R()   
    {
      myservo.write(177);
      int Rdistance= Dist.getDistanceCentimeter();     
      Serial.print("R distance:");       
      Serial.println(Rdistance);        
      Rspeedd = Rdistance;
    }  
    
void loop()
 {
    myservo.write(90);  
    detection();       
      
   if(directionn == 2)            
   {
     back(8);                    
     turnL(2);                   
     Serial.print(" Reverse ");   
   }
   if(directionn == 6)           
   {
     back(1); 
     turnR(6);                   
     Serial.print(" Right ");   
   }
   if(directionn == 4)           
   {  
     back(1);      
     turnL(6);                 
     Serial.print(" Left ");     
   }  
   if(directionn == 8)           
   { 
    advance(1);                
    Serial.print(" Advance ");   
    Serial.print("   ");    
   }
 }


